<?php

require_once "conexion.php";

class ModeloContratos{

	/*=============================================
	CREAR CONTRATOS
	=============================================*/

	static public function mdlIngresarContratos($tabla, $datos){
		date_default_timezone_set("America/Lima");
		setlocale(LC_ALL, 'spanish');

		$estado = 0;
		$con = Conexion::conectar();

		$stmt = $con->prepare("INSERT INTO $tabla(codigo, idusuario, idpersona, numromeses, idtipo_servicios, direccion, fecha_instalacion, fecha_facturacion, estado, clausula_contrato, equipos_asignados) VALUES (:codigo, :idusuario, :idpersona, :numromeses, :idtipo_servicios, :direccion, :fecha_instalacion, :fecha_facturacion, :estado, :clausula_contrato, :equipos_asignados)");


		$stmt->bindParam(":codigo", $datos["codigo"], PDO::PARAM_INT);
		$stmt->bindParam(":idusuario", $datos["idusuario"], PDO::PARAM_INT);
		$stmt->bindParam(":idpersona", $datos["idpersona"], PDO::PARAM_INT);
		$stmt->bindParam(":numromeses", $datos["numromeses"], PDO::PARAM_STR);
		$stmt->bindParam(":direccion", $datos["direccion"], PDO::PARAM_STR);
		$stmt->bindParam(":fecha_instalacion", $datos["fecha_instalacion"], PDO::PARAM_STR);
		$stmt->bindParam(":fecha_facturacion", $datos["fecha_facturacion"], PDO::PARAM_STR);
		$stmt->bindParam(":idtipo_servicios", $datos["idtipo_servicios"], PDO::PARAM_INT);

		$stmt->bindParam(":clausula_contrato", $datos["clausula_contrato"], PDO::PARAM_STR);
		$stmt->bindParam(":equipos_asignados", $datos["equipos_asignados"], PDO::PARAM_STR);
		$stmt->bindParam(":estado", $estado, PDO::PARAM_INT);

		if($stmt->execute()){
			$idd = $con->lastInsertId();

			return $idd;

		}else{


			return "error";

		}

		$stmt = null;

	}



	static public function mdlIngresarCronogramaPagos($datos){
    date_default_timezone_set("America/Lima");
    setlocale(LC_ALL, 'spanish');
    $con = Conexion::conectar();
    try {
        $stmt = $con->prepare("INSERT INTO cronograma_pago(idservicios,monto,fechas_pagos,estado) VALUES (:servicio,:monto,:fechas_pagos,:estado)");
        $con->beginTransaction();

        for ($i = 0; $i < $datos["numromeses"]; $i++) {
            $stmt->execute([
                'servicio' => $datos["idservicios"],
                'monto' => $datos["montos"][$i],
                'fechas_pagos' => $datos["fechas"][$i],
                'estado' => $datos["estado"]
            ]);
        }
        
        $con->commit();
        return "ok";
    } catch(Exception $e) {
        $con->rollBack();
        return "error";
    }
}

	/*=============================================
	CREAR CONTRATOS DESDE VENTAS
	=============================================*/

	static public function mdlIngresarContratosV($tabla, $datos){
		date_default_timezone_set("America/Lima");
		setlocale(LC_ALL, 'spanish');

		$estado = 5;
		$con = Conexion::conectar();

		$stmt = $con->prepare("INSERT INTO $tabla(codigo, idusuario, idpersona, numromeses, idtipo_servicios, direccion, fecha_instalacion, fecha_facturacion, estado, clausula_contrato, equipos_asignados) VALUES (:codigo, :idusuario, :idpersona, :numromeses, :idtipo_servicios, :direccion, :fecha_instalacion, :fecha_facturacion, :estado, :clausula_contrato, :equipos_asignados)");


		$stmt->bindParam(":codigo", $datos["codigo"], PDO::PARAM_INT);
		$stmt->bindParam(":idusuario", $datos["idusuario"], PDO::PARAM_INT);
		$stmt->bindParam(":idpersona", $datos["idpersona"], PDO::PARAM_INT);
		$stmt->bindParam(":numromeses", $datos["numromeses"], PDO::PARAM_STR);
		$stmt->bindParam(":direccion", $datos["direccion"], PDO::PARAM_STR);
		$stmt->bindParam(":fecha_instalacion", $datos["fecha_instalacion"], PDO::PARAM_STR);
		$stmt->bindParam(":fecha_facturacion", $datos["fecha_facturacion"], PDO::PARAM_STR);
		$stmt->bindParam(":idtipo_servicios", $datos["idtipo_servicios"], PDO::PARAM_INT);

		$stmt->bindParam(":clausula_contrato", $datos["clausula_contrato"], PDO::PARAM_STR);
		$stmt->bindParam(":equipos_asignados", $datos["equipos_asignados"], PDO::PARAM_STR);
		$stmt->bindParam(":estado", $estado, PDO::PARAM_INT);

		if($stmt->execute()){
			$idd = $con->lastInsertId();

			return $idd;

		}else{


			return "error";

		}

		$stmt = null;

	}



	static public function mdlIngresarCronogramaPagosV($datos){
    date_default_timezone_set("America/Lima");
    setlocale(LC_ALL, 'spanish');
    $con = Conexion::conectar();
    try {
        $stmt = $con->prepare("INSERT INTO cronograma_pago(idservicios,monto,fechas_pagos,estado) VALUES (:servicio,:monto,:fechas_pagos,:estado)");
        $con->beginTransaction();

        for ($i = 0; $i < $datos["numromeses"]; $i++) {
            $stmt->execute([
                'servicio' => $datos["idservicios"],
                'monto' => $datos["montos"][$i],
                'fechas_pagos' => $datos["fechas"][$i],
                'estado' => $datos["estado"]
            ]);
        }
        
        $con->commit();
        return "ok";
    } catch(Exception $e) {
        $con->rollBack();
        return "error";
    }
}

	/*=============================================
	AQUI TERMINA
	=============================================*/


	/*=============================================
	MOSTRAR CONTRATOS
	=============================================*/

	static public function mdlMostrarContratos($tabla, $item, $valor){

		if($item != null){

			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item = :$item ORDER BY idservicios DESC");

			$stmt -> bindParam(":".$item, $valor, PDO::PARAM_STR);

			$stmt -> execute();

			return $stmt -> fetch();

		}else{

			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla ORDER BY idservicios DESC");

			$stmt -> execute();

			return $stmt -> fetchAll();

		}


		$stmt = null;

	}
	static public function mdlRecuperacionR($tabla, $item, $valor){

		if($item != null){

			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla");

			$stmt -> bindParam(":".$item, $valor, PDO::PARAM_STR);

			$stmt -> execute();

			return $stmt -> fetch();

		}else{

			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla");

			$stmt -> execute();

			return $stmt -> fetchAll();

		}


		$stmt = null;

	}
		static public function mdlDetalleCobRed($tabla, $item, $valor){

		if($item != null){

			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla");

			$stmt -> bindParam(":".$item, $valor, PDO::PARAM_STR);

			$stmt -> execute();

			return $stmt -> fetch();

		}else{

			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla");

			$stmt -> execute();

			return $stmt -> fetchAll();

		}


		$stmt = null;

	}
		static public function mdlPagosR($tabla, $item, $valor){

		if($item != null){

			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla");

			$stmt -> bindParam(":".$item, $valor, PDO::PARAM_STR);

			$stmt -> execute();

			return $stmt -> fetch();

		}else{

			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla");

			$stmt -> execute();

			return $stmt -> fetchAll();

		}


		$stmt = null;

	}

		static public function mdlMostrarContratosCodigo($tabla, $item, $valor){

		if($item != null){

			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item = :$item ORDER BY idservicios ASC");

			$stmt -> bindParam(":".$item, $valor, PDO::PARAM_STR);

			$stmt -> execute();

			return $stmt -> fetch();

		}else{

			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla ORDER BY idservicios ASC");

			$stmt -> execute();

			return $stmt -> fetchAll();

		}


		$stmt = null;

	}




	static public function mdlMostrarContratosReporte($tabla, $item, $valor){


			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item = :$item");

			$stmt -> bindParam(":".$item, $valor, PDO::PARAM_STR);

			$stmt -> execute();

			return $stmt -> fetchAll();




		$stmt = null;

	}

	static public function mdlMostrarServiciosReporte($tabla, $valor,$valor2,$valor3){

		if($valor3 != "" && $valor2 != "" && $valor != ""){
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE idtipo_servicios = :item AND estado_servicio = :estado AND idzona = :zona");

			$stmt -> bindParam(":item", $valor, PDO::PARAM_INT);
			$stmt -> bindParam(":estado", $valor2, PDO::PARAM_INT);
			$stmt -> bindParam(":zona", $valor3, PDO::PARAM_STR);

			$stmt -> execute();

			return $stmt -> fetchAll();

		}else if ($valor != "" && $valor2 != "") {
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE idtipo_servicios = :item AND estado_servicio = :estado");

			$stmt -> bindParam(":item", $valor, PDO::PARAM_INT);
			$stmt -> bindParam(":estado", $valor2, PDO::PARAM_INT);

			$stmt -> execute();

			return $stmt -> fetchAll();

		}else if ($valor != "" && $valor3 != ""){
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE idtipo_servicios = :item AND idzona = :zona");

			$stmt -> bindParam(":item", $valor, PDO::PARAM_INT);
			$stmt -> bindParam(":zona", $valor3, PDO::PARAM_STR);

			$stmt -> execute();

			return $stmt -> fetchAll();

		}else if($valor2 != "" && $valor3 != ""){
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE estado_servicio = :estado AND idzona = :zona");

			$stmt -> bindParam(":estado", $valor2, PDO::PARAM_INT);
			$stmt -> bindParam(":zona", $valor3, PDO::PARAM_STR);

			$stmt -> execute();

			return $stmt -> fetchAll();

		}else if($valor3 != ""){
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE idzona = :zona");

			$stmt -> bindParam(":zona", $valor3, PDO::PARAM_STR);

			$stmt -> execute();

			return $stmt -> fetchAll();

		}else if($valor2 != ""){
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE estado_servicio = :estado");

			$stmt -> bindParam(":estado", $valor2, PDO::PARAM_INT);

			$stmt -> execute();
			return $stmt -> fetchAll();
		}else if($valor != ""){
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE idtipo_servicios = :item");

			$stmt -> bindParam(":item", $valor, PDO::PARAM_INT);

			$stmt -> execute();
			return $stmt -> fetchAll();
		}else{
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla");

			$stmt -> execute();
			return $stmt -> fetchAll();
		}



		$stmt = null;

	}


	static public function mdlEditarServicio($tabla, $item, $valor){

		if($item != null){

			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item = :$item");

			$stmt -> bindParam(":".$item, $valor, PDO::PARAM_STR);

			$stmt -> execute();

			return $stmt -> fetchall();

		}else{

			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla");

			$stmt -> execute();

			return $stmt -> fetchAll();

		}


		$stmt = null;

	}




	static public function mdlMostrarCobros($tabla, $item, $valor){

		if($item != null){

			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item = :$item");

			$stmt -> bindParam(":".$item, $valor, PDO::PARAM_STR);

			$stmt -> execute();

			return $stmt -> fetchAll();

		}else{

			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla");

			$stmt -> execute();

			return $stmt -> fetchAll();

		}


		$stmt = null;

	}


	static public function ctrComprobarServicio($tabla, $item, $valor){

		$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE estado = 1 AND $item = :$item ");

		$stmt -> bindParam(":".$item, $valor, PDO::PARAM_STR);

		$stmt -> execute();

		return $stmt -> fetch();



		$stmt = null;

	}

	static public function mdlEliminarServicio($tabla, $item, $valor){


		$stmt = Conexion::conectar()->prepare("DELETE FROM servicios WHERE idservicios = :idservicios");

		$stmt -> bindParam(":idservicios", $valor, PDO::PARAM_INT);

		if($stmt -> execute()){

			return "ok";

		}else{

			return "error";

		}


		$stmt = null;

	}
	
	static public function mdlbajaServicio($tabla, $item, $valor){


		$stmt = Conexion::conectar()->prepare("UPDATE servicios SET estado = 4 WHERE idservicios = :idservicios;");

		$stmt -> bindParam(":idservicios", $valor, PDO::PARAM_INT);

		if($stmt -> execute()){

			return "ok";

		}else{

			return "error";

		}


		$stmt = null;

	}
    static public function mdlValidaServicioCobros($tabla, $item, $valor){


		$stmt = Conexion::conectar()->prepare("UPDATE servicios SET estado = 0 WHERE idservicios = :idservicios;");

		$stmt -> bindParam(":idservicios", $valor, PDO::PARAM_INT);

		if($stmt -> execute()){

			return "ok";

		}else{

			return "error";

		}


		$stmt = null;

	}

	static public function mdlEliminarServicioCobros($tabla, $item, $valor){


		$stmt = Conexion::conectar()->prepare("DELETE FROM cronograma_pago WHERE idservicios = :idservicios");

		$stmt -> bindParam(":idservicios", $valor, PDO::PARAM_INT);

		if($stmt -> execute()){

			return "ok";

		}else{

			return "error";

		}


		$stmt = null;

	}

	static public function mdlBajaServicioCobros($tabla, $item, $valor){


		$stmt = Conexion::conectar()->prepare("UPDATE cronograma_pago SET estado = 4 WHERE idservicios = :idservicios AND (estado = 0 OR estado = 2);");

		$stmt -> bindParam(":idservicios", $valor, PDO::PARAM_INT);

		if($stmt -> execute()){

			return "ok";

		}else{

			return "error";

		}


		$stmt = null;

	}
	static public function mdlValidaServicioCro($tabla, $item, $valor){


		$stmt = Conexion::conectar()->prepare("UPDATE cronograma_pago SET estado = 0 WHERE idservicios = :idservicios AND (estado = 5);");

		$stmt -> bindParam(":idservicios", $valor, PDO::PARAM_INT);

		if($stmt -> execute()){

			return "ok";

		}else{

			return "error";

		}


		$stmt = null;

	}


	/*=============================================
	EDITAR CONTRATOS
	=============================================*/

	static public function mdlEditarContratos($tabla, $datos){

		$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET idservicios = :idservicios, codigo = :codigo, idusuario = :idusuario, idpersona= :idpersona, numromeses= :numromeses, direccion = :direccion, fecha_instalacion = :fecha_instalacion, fecha_facturacion = :fecha_facturacion, idtipo_servicios= :idtipo_servicios WHERE idservicios = :idservicios");

		$stmt->bindParam(":idservicios", $datos["idservicios"], PDO::PARAM_INT);
		$stmt->bindParam(":codigo", $datos["codigo"], PDO::PARAM_INT);
		$stmt->bindParam(":idusuario", $datos["idusuario"], PDO::PARAM_INT);
		$stmt->bindParam(":idpersona", $datos["idpersona"], PDO::PARAM_INT);
		$stmt->bindParam(":numromeses", $datos["numromeses"], PDO::PARAM_STR);
		$stmt->bindParam(":direccion", $datos["direccion"], PDO::PARAM_STR);
		$stmt->bindParam(":fecha_instalacion", $datos["fecha_instalacion"], PDO::PARAM_STR);
		$stmt->bindParam(":fecha_facturacion", $datos["fecha_facturacion"], PDO::PARAM_STR);
		$stmt->bindParam(":idtipo_servicios", $datos["idtipo_servicios"], PDO::PARAM_INT);



		if($stmt->execute()){

			return "ok";

		}else{

			return "error";

		}

		$stmt = null;

	}

	/*=============================================
	ELIMINAR CONTRATOS OJO
	=============================================*/

	static public function mdlEliminarContrato($tabla, $datos){

		$stmt = Conexion::conectar()->prepare("DELETE FROM $tabla WHERE idpersona = :idpersona");

		$stmt -> bindParam(":idpersona", $datos, PDO::PARAM_INT);

		if($stmt -> execute()){

			return "ok";

		}else{

			return "error";

		}


		$stmt = null;

	}


	/*=============================================
	ACTUALIZAR CONTRARO
	=============================================*/

	static public function mdlActualizarContrato($tabla, $item1, $valor1, $valor){

		$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET $item1 = :$item1 WHERE id = :id");

		$stmt -> bindParam(":".$item1, $valor1, PDO::PARAM_STR);
		$stmt -> bindParam(":id", $valor, PDO::PARAM_STR);

		if($stmt -> execute()){

			return "ok";

		}else{

			return "error";

		}


		$stmt = null;

	}

	static public function mdlcontarContratos($tabla, $item, $valor){
		//select count(*) as total from servicios where estado = 1
		if($item != null){
			$stmt = Conexion::conectar()->prepare("SELECT count(*) as total FROM $tabla WHERE $item = :$item");
			$stmt -> bindParam(":".$item, $valor, PDO::PARAM_STR);
		} else {
			$stmt = Conexion::conectar()->prepare("SELECT count(*) as total FROM $tabla");
		}
		$stmt -> execute();
		return $stmt -> fetchColumn();
		$stmt = null;
	}

	static public function mdlcontarContratosDescripcion($valor, $fecha1, $fecha2){
		//select count(*) from servicios as ser inner join tipo_servicios as tipo on ser.idtipo_servicios=tipo.idtipo_servicios where descripcion = "Domiciliar" and  ser.fecha_facturacion BETWEEN "2021-07-05" and "2021-07-20"
		//select sum(importeCaja) as total from detallecaja where concepto = "Comercial" and fechaRegistro BETWEEN "2021-02-14" and "2021-02-14"

		if($fecha1 == null and $fecha2 == null){
			//$stmt = Conexion::conectar()->prepare("SELECT SUM(tipo.valor_servicio) from servicios as ser inner join tipo_servicios as tipo on ser.idtipo_servicios=tipo.idtipo_servicios where descripcion = :descripcion");
			$stmt = Conexion::conectar()->prepare("SELECT sum(importeCaja) as total from detallecaja where concepto = :descripcion");
			$stmt -> bindParam(":descripcion", $valor, PDO::PARAM_STR);

		} else {
			//$stmt = Conexion::conectar()->prepare("SELECT SUM(tipo.valor_servicio) from servicios as ser inner join tipo_servicios as tipo on ser.idtipo_servicios=tipo.idtipo_servicios where descripcion = :descripcion and  ser.fecha_facturacion BETWEEN :fecha1 and :fecha2");
			$stmt = Conexion::conectar()->prepare("SELECT sum(importeCaja) as total from detallecaja where concepto = :descripcion and fechaRegistro BETWEEN :fecha1 and :fecha2");
			$stmt -> bindParam(":descripcion", $valor, PDO::PARAM_STR);
			$stmt -> bindParam(":fecha1", $fecha1, PDO::PARAM_STR);
			$stmt -> bindParam(":fecha2", $fecha2, PDO::PARAM_STR);
		}



		$stmt -> execute();
		return $stmt -> fetchColumn();
		$stmt = null;
	}

	static public function mdlObtenerCobrosDiariosPorZona(){
		try {
			// Obtener cobros diarios por zona de los últimos 15 días
			$stmt = Conexion::conectar()->prepare("
				SELECT 
					DATE(cp.fechas_pagos) as fecha,
					z.nombre_zona,
					z.idzona,
					COUNT(*) as total_cobros,
					SUM(cp.monto) as total_monto
				FROM cronograma_pago cp
				INNER JOIN servicios s ON cp.idservicios = s.idservicios
				INNER JOIN persona p ON s.idpersona = p.idpersona
				INNER JOIN zona z ON p.id_zona = z.idzona
				WHERE cp.estado = 1
				AND cp.fechas_pagos >= DATE_SUB(CURDATE(), INTERVAL 15 DAY)
				AND cp.fechas_pagos <= CURDATE()
				GROUP BY DATE(cp.fechas_pagos), z.idzona, z.nombre_zona
				ORDER BY fecha ASC, z.nombre_zona ASC
			");
			
			$stmt->execute();
			$resultado = $stmt->fetchAll(PDO::FETCH_ASSOC);
			$stmt->closeCursor();
			$stmt = null;
			
			return $resultado;
		} catch (Exception $e) {
			error_log("Error en mdlObtenerCobrosDiariosPorZona: " . $e->getMessage());
			return [];
		}
	}

	static public function mdlObtenerAnalisisMensual(){
		try {
			// Consulta exacta como la del usuario para obtener datos reales del mes actual
			$stmt = Conexion::conectar()->prepare("
				SELECT 
					estado,
					CASE 
						WHEN estado = 4 THEN 'Bajas del Mes'
						WHEN estado = 1 THEN 'Pagos Realizados'
						WHEN estado = 0 THEN 'Pagos Pendientes'
						WHEN estado = 2 THEN 'Pagos Atrasados'
						ELSE 'Otro'
					END AS categoria,
					SUM(monto) AS monto,
					COUNT(*) AS cantidad
				FROM cronograma_pago 
				WHERE fechas_pagos BETWEEN CONCAT(YEAR(CURDATE()), '-', LPAD(MONTH(CURDATE()), 2, '0'), '-01') 
					AND LAST_DAY(CURDATE())
				GROUP BY estado
				ORDER BY estado
			");
			
			$stmt->execute();
			$resultado = $stmt->fetchAll(PDO::FETCH_ASSOC);
			$stmt->closeCursor();
			$stmt = null;
			
			return $resultado;
		} catch (Exception $e) {
			error_log("Error en mdlObtenerAnalisisMensual: " . $e->getMessage());
			return [];
		}
	}

	static public function mdlObtenerCobrosAnualesPorMes(){
		try {
			// Obtener cobros del año actual segmentados por mes desde tabla cobros
			$stmt = Conexion::conectar()->prepare("
				SELECT 
					MONTH(fecha_cobro) as mes_numero,
					CASE MONTH(fecha_cobro)
						WHEN 1 THEN 'Enero'
						WHEN 2 THEN 'Febrero'
						WHEN 3 THEN 'Marzo'
						WHEN 4 THEN 'Abril'
						WHEN 5 THEN 'Mayo'
						WHEN 6 THEN 'Junio'
						WHEN 7 THEN 'Julio'
						WHEN 8 THEN 'Agosto'
						WHEN 9 THEN 'Septiembre'
						WHEN 10 THEN 'Octubre'
						WHEN 11 THEN 'Noviembre'
						WHEN 12 THEN 'Diciembre'
					END as mes_nombre,
					SUM(total) as total_cobros,
					COUNT(*) as cantidad_cobros
				FROM cobros 
				WHERE YEAR(fecha_cobro) = YEAR(CURDATE())
				GROUP BY MONTH(fecha_cobro)
				ORDER BY mes_numero
			");
			
			$stmt->execute();
			$resultado = $stmt->fetchAll(PDO::FETCH_ASSOC);
			$stmt->closeCursor();
			$stmt = null;
			
			return $resultado;
		} catch (Exception $e) {
			error_log("Error en mdlObtenerCobrosAnualesPorMes: " . $e->getMessage());
			return [];
		}
	}

	static public function mdlObtenerRecaudacionPorMetodoPago(){
		try {
			// Obtener recaudación por método de pago y banco desde tabla cobros
			$stmt = Conexion::conectar()->prepare("
				SELECT 
					mpago as metodo_pago,
					banco,
					SUM(total) as total_recaudado,
					COUNT(*) as cantidad_transacciones
				FROM cobros 
				WHERE YEAR(fecha_cobro) = YEAR(CURDATE())
				GROUP BY mpago, banco
				ORDER BY total_recaudado DESC
			");
			
			$stmt->execute();
			$resultado = $stmt->fetchAll(PDO::FETCH_ASSOC);
			$stmt->closeCursor();
			$stmt = null;
			
			return $resultado;
		} catch (Exception $e) {
			error_log("Error en mdlObtenerRecaudacionPorMetodoPago: " . $e->getMessage());
			return [];
		}
	}

	static public function mdlObtenerIngresosPorZona(){
		try {
			// Consulta para obtener datos de pagos por zona y estado
			$stmt = Conexion::conectar()->prepare("
				SELECT 
					z.nombre_zona,
					z.idzona,
					cp.estado,
					COUNT(*) as cantidad,
					SUM(cp.monto) as total_monto,
					CASE 
						WHEN cp.estado = 1 THEN 'Pagado'
						WHEN cp.estado = 0 THEN 'Pendiente'
						WHEN cp.estado = 2 THEN 'Atrasado'
						WHEN cp.estado = 4 THEN 'Baja'
						ELSE 'Desconocido'
					END as estado_descripcion
				FROM zona z
				INNER JOIN persona p ON z.idzona = p.id_zona
				INNER JOIN servicios s ON p.idpersona = s.idpersona
				INNER JOIN cronograma_pago cp ON s.idservicios = cp.idservicios
				WHERE p.estado = 'activo'
				GROUP BY z.idzona, z.nombre_zona, cp.estado
				ORDER BY z.nombre_zona, cp.estado
			");
			
			$stmt->execute();
			$resultado = $stmt->fetchAll(PDO::FETCH_ASSOC);
			$stmt->closeCursor();
			$stmt = null;
			
			return $resultado;
		} catch (Exception $e) {
			error_log("Error en mdlObtenerIngresosPorZona: " . $e->getMessage());
			return [];
		}
	}


}
